import type { Metadata } from "next";
import { Bricolage_Grotesque } from "next/font/google";
import "./globals.css";
import Footer from "@/components/globals/footer";
import Navbar from "@/components/globals/header-nav";


const bricolage = Bricolage_Grotesque({
  weight : ["200", "300", "400", "500", "600", "700"],
  variable : "--font-primary",
  subsets : ["latin"]
})

const publicSans = Bricolage_Grotesque({
  weight : ["200", "300", "400", "500", "600", "700"],
  variable : "--font-secondary",
  subsets : ["latin"]
})



export const metadata: Metadata = {
  title: "Create Next App",
  description: "Generated by create next app",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body
        className={`${bricolage.variable} ${publicSans.variable} antialiased`}
      >
        <Navbar />
          {children}
        <Footer />
      </body>
    </html>
  );
}
